/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.Emulator;
import jace.EmulatorUILogic;
import jace.apple2e.SoftSwitches;
import jace.apple2e.Speaker;
import jace.apple2e.softswitch.KeyboardSoftSwitch;
import jace.config.ConfigurationPanel;
import jace.config.Reconfigurable;
import jace.core.Card;
import jace.core.Computer;
import jace.hardware.CardDiskII;
import jace.hardware.massStorage.CardMassStorage;
import jace.ui.MainFrame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class Keyboard
implements Reconfigurable {
    static byte currentKey = 0;
    static StringReader pasteBuffer = null;

    public static void clearStrobe() {
        currentKey = (byte)(currentKey & 0x7F);
    }

    public static void pressKey(byte key) {
        currentKey = (byte)(0xFF & (0x80 | key));
    }

    public static byte readState() {
        int newKey;
        if ((currentKey & 0x80) == 0 && (newKey = Keyboard.getClipboardKeystroke()) >= 0) {
            Keyboard.pressKey((byte)newKey);
        }
        return currentKey;
    }

    public KeyListener getListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 0 || e.isConsumed()) {
                    return;
                }
                KeyboardSoftSwitch key = (KeyboardSoftSwitch)SoftSwitches.KEYBOARD.getSwitch();
                int c = e.getKeyChar();
                if ((e.getModifiers() & 8) > 0) {
                    if (e.getKeyLocation() == 2) {
                        this.pressOpenApple();
                    } else if (e.getKeyLocation() == 3) {
                        this.pressSolidApple();
                    }
                }
                int code = e.getKeyCode();
                switch (code) {
                    case 37: 
                    case 226: {
                        c = 8;
                        break;
                    }
                    case 39: 
                    case 227: {
                        c = 21;
                        break;
                    }
                    case 38: 
                    case 224: {
                        c = 11;
                        break;
                    }
                    case 40: 
                    case 225: {
                        c = 10;
                        break;
                    }
                    case 9: {
                        c = 9;
                        break;
                    }
                    case 10: {
                        c = 13;
                        break;
                    }
                    case 8: {
                        c = 127;
                        break;
                    }
                    default: {
                        if ((e.getModifiers() & 0x80) <= 0) break;
                        c = (char)(code - 65 + 1);
                    }
                }
                if (c < 128) {
                    Keyboard.pressKey((byte)c);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                File newDisk;
                JFileChooser select;
                Card drive;
                int code;
                block28: {
                    block27: {
                        code = e.getKeyCode();
                        if (code == 0 || e.isConsumed()) {
                            return;
                        }
                        if (code == 155 && e.isShiftDown()) {
                            Keyboard.doPaste();
                        }
                        if (code == 121) {
                            MainFrame.instance.showDebug = MainFrame.instance.showDebug == false;
                            MainFrame.instance.reconfigure();
                            Emulator.resizeVideo();
                        }
                        if (code == 123) break block27;
                        if (code == 33) break block27;
                        if (code == 8) break block27;
                        if (code != 19) break block28;
                    }
                    if ((e.getModifiers() & 2) > 0) {
                        Computer.getComputer().warmStart();
                    }
                }
                if (code == 112 && (drive = (CardDiskII)Computer.getComputer().getMemory().getCard(6)) != null) {
                    select = new JFileChooser();
                    select.showDialog(MainFrame.instance, "Insert disk in S6 D1");
                    newDisk = select.getSelectedFile();
                    if (newDisk != null) {
                        ((CardDiskII)drive).disk1 = newDisk;
                        ((CardDiskII)drive).reconfigure();
                    }
                }
                if (code == 113 && (drive = (CardDiskII)Computer.getComputer().getMemory().getCard(6)) != null) {
                    select = new JFileChooser();
                    select.showDialog(MainFrame.instance, "Insert disk in S6 D2");
                    newDisk = select.getSelectedFile();
                    if (newDisk != null) {
                        ((CardDiskII)drive).disk2 = newDisk;
                        ((CardDiskII)drive).reconfigure();
                    }
                }
                if (code == 114 && (drive = (CardMassStorage)Computer.getComputer().getMemory().getCard(7)) != null) {
                    select = new JFileChooser();
                    select.showDialog(MainFrame.instance, "Attach hard drive");
                    newDisk = select.getSelectedFile();
                    if (newDisk != null) {
                        if (newDisk.isFile()) {
                            newDisk = newDisk.getParentFile();
                        }
                        ((CardMassStorage)drive).disk1path = newDisk;
                        ((CardMassStorage)drive).reconfigure();
                    }
                }
                if (code == 115) {
                    JFrame f = new JFrame();
                    f.setContentPane(new ConfigurationPanel());
                    f.setSize(f.getContentPane().getPreferredSize());
                    f.validate();
                    f.setDefaultCloseOperation(2);
                    f.setVisible(true);
                }
                if (code == 116) {
                    EmulatorUILogic.runFile();
                }
                if (code == 118) {
                    Speaker.toggleFileOutput();
                }
                if (code == 119) {
                    EmulatorUILogic.scaleIntegerRatio();
                }
                if (code == 154) {
                    Computer.getComputer().getCpu().setHalt(true);
                    try {
                        JFileChooser select2 = new JFileChooser();
                        select2.showSaveDialog(MainFrame.instance);
                        BufferedImage i = Computer.getComputer().getVideo().video;
                        File targetFile = select2.getSelectedFile();
                        if (targetFile == null) {
                            Computer.getComputer().getCpu().setHalt(false);
                            return;
                        }
                        String filename = targetFile.getName();
                        System.out.println("Writing screenshot to " + filename);
                        String extension = filename.substring(filename.lastIndexOf(".") + 1);
                        ImageIO.write((RenderedImage)i, extension, targetFile);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Keyboard.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    Computer.getComputer().getCpu().setHalt(false);
                }
                if (code == 18) {
                    if (e.getKeyLocation() == 2) {
                        this.releaseOpenApple();
                    } else if (e.getKeyLocation() == 3) {
                        this.releaseSolidApple();
                    }
                }
                e.consume();
            }

            private void pressOpenApple() {
                SoftSwitches.PB0.getSwitch().setState(true);
            }

            private void pressSolidApple() {
                SoftSwitches.PB1.getSwitch().setState(true);
            }

            private void releaseOpenApple() {
                SoftSwitches.PB0.getSwitch().setState(false);
            }

            private void releaseSolidApple() {
                SoftSwitches.PB1.getSwitch().setState(false);
            }
        };
    }

    public static void doPaste(String text) {
        pasteBuffer = new StringReader(text);
    }

    private static void doPaste() {
        try {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            String contents = (String)clip.getData(DataFlavor.stringFlavor);
            if (contents != null && !"".equals(contents)) {
                contents = contents.replaceAll("\\n(\\r)?", "\r");
                pasteBuffer = new StringReader(contents);
            }
        }
        catch (UnsupportedFlavorException ex) {
            Logger.getLogger(Keyboard.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(Keyboard.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static int getClipboardKeystroke() {
        if (pasteBuffer == null) {
            return -1;
        }
        try {
            int keypress = pasteBuffer.read();
            if (keypress == -1) {
                pasteBuffer.close();
                pasteBuffer = null;
                return -1;
            }
            KeyboardSoftSwitch key = (KeyboardSoftSwitch)SoftSwitches.KEYBOARD.getSwitch();
            return keypress & 0xFF;
        }
        catch (IOException ex) {
            Logger.getLogger(Keyboard.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    @Override
    public String getName() {
        return "Keyboard";
    }

    @Override
    public void reconfigure() {
    }
}

